// By EVOLVED
// www.evolved-software.com

//--------------
// un-tweaks
//--------------
   uniform mat4 agk_WorldViewProj;
   uniform mat4 agk_ViewProj;
   uniform mat4 agk_World;
   uniform mat3 agk_WorldNormal;
   uniform vec4 uvBounds0;

//--------------
// tweaks
//--------------
   uniform vec4 TreeWindTimer;
   uniform vec4 TreeWindSize;
   uniform vec3 TreeWindPower;

//--------------
// attributes
//--------------
    attribute vec3 position;
    attribute vec2 uv;
    attribute vec3 normal;
    attribute vec3 color;

//--------------
// Vs Out
//--------------
    varying vec2 Vs_Tex;

//--------------
// vertex shader
//--------------
   void main()
     {
	vec3 WorldPos=(agk_World*vec4(position,1.0)).xyz;
	vec3 Normals=normalize(agk_WorldNormal*normal);
	vec3 GlobalWind=(WorldPos.xyz/TreeWindSize.x)+TreeWindTimer.x;
	GlobalWind=vec3(cos(GlobalWind.x),0.0,sin(GlobalWind.z));
	GlobalWind.y=1+abs(dot(GlobalWind.x,GlobalWind.z));
   	vec3 WindForce=(WorldPos.xyz/TreeWindSize.x)+TreeWindTimer.y-GlobalWind;
	WindForce=vec3(cos(WindForce.x),0.0,sin(WindForce.y));
	vec3 WindAnimate=WindForce*TreeWindPower.x*(position.y/TreeWindSize.y);
	float WindVariant=TreeWindTimer.z+(color.y*10);
	WindAnimate.xz +=vec2(cos(WindVariant),sin(WindVariant))*TreeWindPower.y*color.z;
	vec3 WindFlutter=(WorldPos.xyz/TreeWindSize.w)+(TreeWindTimer.w)+color.y;
	WindAnimate +=abs(Normals)*sin(dot(WindFlutter,vec3(1.0,1.0,1.0)))*TreeWindPower.z*color.x;
	WorldPos +=WindAnimate*GlobalWind.y;
	gl_Position=agk_ViewProj*vec4(WorldPos,1);
	Vs_Tex=uv*uvBounds0.xy+uvBounds0.zw;
     }